<?php
/**
 * Batches Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Batches extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Batches_model');
		$this->load->model('Trainees_model');
		$this->load->model('Companies_model');
		$this->load->model('Programs_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Batch';
		
		if(check_roles('1') or check_roles('2')){
			$this->twiggy_display('adm/batches/index', $data);
		}else{
			redirect("Error");
		}
	}
	 
	public function get_data_header()
	{	
		$data = [];
		$get_data = $this->Batches_model->batch_header()->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$percentage = 0;
				$all_date   = $get_row->all_date;
				$running    = $get_row->running;
				$done       = $get_row->done;

				if($all_date > 0){
					if($done > 0){
						$percentage = round(($done/$all_date) * 100, 2);
					}
				}

				$accr = '';
				if($get_row->program_header_accreditation_id != 0){
					$accr = '<span class="badge badge-info">'.$get_row->program_accreditation_name.'</span>';
				}

				$data[] = array(
					'no'         => $no,
					'id'         => $get_row->batch_header_id,
					'name'       => $get_row->batch_header_name,
					'program'    => $get_row->program_header_name.' '.$accr,
					'program_name'    => $get_row->program_header_name,
					'class'      => $get_row->program_class_name,
					'type'       => $get_row->program_type_name,
					'date'       => indonesian_date($get_row->batch_header_start). ' - ' .indonesian_date($get_row->batch_header_end),
					'all_date'   => $all_date,
					'running'    => $running,
					'done'       => $done,
					'percentage' => $percentage.' %',
					'meeting_type'       => $get_row->batch_header_meeting_type,
					'info'       => $get_row->batch_header_info,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
	}

 	public function edit($id = 'new', $type = 'detail')
	{
		$title       = "Tambah Batch";
		$header_data = array(null);
		$date_start  = change_format_date(date_now(), 'd/m/Y');
		$date_end    = change_format_date(date_now(), 'd/m/Y');

	    if($id != 'new')
	    {
			$title       = "Edit Batch";
			$header_data = $this->Batches_model->batch_header($id)->row_array();
			$date_start = change_format_date($header_data['batch_header_start'], 'd/m/Y');
			$date_end   = change_format_date($header_data['batch_header_end'], 'd/m/Y');
		}
		$meeting_type = [
			[
				'meet_id'   => 'Online',
				'meet_name' => 'Online'
			],
			[
				'meet_id'   => 'Offline',
				'meet_name' => 'Offline'
			],
			[
				'meet_id'   => 'Online - Offline',
				'meet_name' => 'Online - Offline'
			],
		];
		
		$data['meeting_type_data']  = $meeting_type;
		
		$data['id']            = $id;
		$data['type']          = $type;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['date_start']    = $date_start;
		$data['date_end']      = $date_end;
		$data['program_data']  = $this->Programs_model->program_header()->result();

		if(check_roles('1') or check_roles('2')){
			$this->twiggy_display('adm/batches/edit', $data);
		}else{
			redirect("Error");
		}
	}

	public function get_data_program()
	{
		$id = $this->input->post('id');

		$get_data = $this->Programs_model->program_header($id)->result();
		echo json_encode($get_data);
	}

	public function get_data_schedule()
	{	
		$id = $this->input->post("id");
		$program = $this->input->post("program");

		$data = [];
		$get_data = $this->Batches_model->meeting_schedules($id, $program)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'number_meeting' => $get_row->meeting_number,
					'date'           => change_format_date($get_row->meeting_date, 'Y-m-d'),
					'duration'       => $get_row->meeting_duration,
					'method'         => $get_row->meeting_method,
					'type'           => $get_row->meeting_type,
					'info'           => $get_row->meeting_info,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_data_detail()
	{	
		$id = $this->input->post("id");

		$data = [];
		$get_data = $this->Batches_model->batch_detail($id)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'no'         => $no,
					'id'         => $get_row->batch_detail_id,
					'traineeid'  => $get_row->trainee_id,
					'code'       => $get_row->trainee_code,
					'name'       => $get_row->trainee_name,
					'job_title'  => $get_row->trainee_job_title_id,
					'company'    => $get_row->company_name,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Peserta';
		$data['companies_data']  = $this->Companies_model->get_data()->result();
		$this->twiggy_display('adm/batches/embed', $data);
	}

	public function get_data_embed()
	{
		$response = [];
		$search   = $this->input->post('search');
		$company  = $this->input->post('company');

		$get_data = $this->Trainees_model->get_data_advance($search, $company)->result();

		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{
				$data[] = array(
					'no'        => $no,
					'id'        => $get_row->trainee_id,
					'code'      => $get_row->trainee_code,
					'name'      => $get_row->trainee_name,
					'job_title' => $get_row->trainee_job_title_id,
					'company'   => $get_row->company_name,
					'btncolor'  => '',
					'btnicon'   => '',
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
		
	}

	public function save()
	{	
		$id      = $this->input->post('id');
		$name    = $this->input->post("name");
		$program = $this->input->post("program");
		$start   = $this->input->post("start");
		$end     = $this->input->post("end");
		$meeting_type    = $this->input->post("meeting_type");
		$info    = $this->input->post("info");
		
		$saveType = $this->input->post('saveType');
		$metdata  = $this->input->post('metdata');
		$vuedata  = $this->input->post('vuedata');
		$header_id   = $id;
		
		$header_data = [
			'batch_header_program_id'   => $program,
			'batch_header_name'         => $name,
			'batch_header_start'        => change_format_date($start),
			'batch_header_end'          => change_format_date($end),
			'batch_header_meeting_type' => $meeting_type,
			'batch_header_info'         => $info,
		];

		$meeting_data = [];
		$detail_data = [];
		$graduate_data = [];

		// echo $saveType;
		// echo json_encode($metdata);
		// die();
		// if save $id = new else update data
		if($id == "new")
		{
			$save_header = $this->Batches_model->save_header($header_data);
			if($save_header)
			{
				$header_id = $this->db->insert_id();
				$get_data_program = $this->Programs_model->program_detail($program)->result();

				foreach($get_data_program as $get_row)
				{
					foreach($vuedata as $row)
					{
						$detail_data[] = [
							'batch_detail_header_id'        => $header_id,
							'batch_detail_program_id'       => $program,
							'batch_detail_trainee_id'       => $row['traineeid'],
							'batch_detail_requirement_id'   => $get_row->requirement_id,
							'batch_detail_requirement_name' => $get_row->requirement_name,
							'status'                        => 0,
						];
					}
				}

				$save_detail = $this->Batches_model->save_detail($detail_data, true);
				
				if($save_detail)
				{
					foreach($vuedata as $row)
					{	
						$row_trainee = $this->Trainees_model->get_data($row['traineeid'])->row();
						$graduate_data[] = [
							'batch_id'     => $header_id,
							'program_id'   => $program,
							'trainee_id'   => $row['traineeid'],
							'job_title_id' => $row_trainee->trainee_job_title_id,
							'company_id'   => $row_trainee->trainee_company_id,
							'status'       => 0,
						];
					}

					$save_graduate = $this->Batches_model->save_graduate($graduate_data, true);

					if($save_graduate)
					{
						foreach($metdata as $row)
						{	
							$meeting_data[] = [
								'batch_id'         => $header_id,
								'program_id'       => $program,
								'meeting_number'   => $row['number_meeting'],
								'meeting_date'     => change_format_date($row['date']),
								'meeting_duration' => $row['duration'],
								'meeting_method'   => $row['method'],
								'meeting_type'     => $row['type'],
								'meeting_info'     => $row['info'],
							];
						}

						$save_schedule = $this->Batches_model->save_meeting_schedules($meeting_data, true);

						if($save_schedule)
						{
							$msg    = "Berhasil menyimpan data";
							$status = "success";
						}else{
							$msg    = "Gagal menyimpan data";
							$status = "error";
						}
					}else{
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
			
		}else{

			if($saveType == 'saveAll'){
				$delete_detail = $this->Batches_model->delete_detail($id);
			}else{
				$delete_detail = true;
			}

			if($delete_detail){
				$save_header = $this->Batches_model->update_header($id, $header_data);

				if($save_header)
				{
					// $header_id = $this->db->insert_id();
					if($saveType == 'saveAll'){
						$get_data_program = $this->Programs_model->program_detail($program)->result();

						foreach($get_data_program as $get_row)
						{
							foreach($vuedata as $row)
							{
								$detail_data[] = [
									'batch_detail_header_id'        => $header_id,
									'batch_detail_program_id'       => $program,
									'batch_detail_trainee_id'       => $row['traineeid'],
									'batch_detail_requirement_id'   => $get_row->requirement_id,
									'batch_detail_requirement_name' => $get_row->requirement_name,
									'status'                        => 0,
								];
							}
						}

						$save_detail = $this->Batches_model->save_detail($detail_data, true);
					}else{
						$save_detail = true;
					}
					
					if($save_detail)
					{	
						if($saveType == 'saveAll'){
							$delete_graduate = $this->Batches_model->delete_graduate($id);
						}else{
							$delete_graduate = true;
						}

						if($delete_graduate){

							if($saveType == 'saveAll'){
								foreach($vuedata as $row)
								{	
									$row_trainee = $this->Trainees_model->get_data($row['traineeid'])->row();
									$graduate_data[] = [
										'batch_id'     => $header_id,
										'program_id'   => $program,
										'trainee_id'   => $row['traineeid'],
										'job_title_id' => $row_trainee->trainee_job_title_id,
										'company_id'   => $row_trainee->trainee_company_id,
										'status'       => 0,
									];
								}

								$save_graduate = $this->Batches_model->save_graduate($graduate_data, true);
							}else{
								$save_graduate = true;
							}

							if($save_graduate)
							{	
								$where = array(
									'batch_id'   => $header_id,
									'program_id' => $program
								);
								$delete_schedule = $this->Batches_model->delete_schedule($where);

								if($delete_schedule){
									foreach($metdata as $row)
									{	
										$meeting_data[] = [
											'batch_id'         => $header_id,
											'program_id'       => $program,
											'meeting_number'   => $row['number_meeting'],
											'meeting_date'     => change_format_date($row['date']),
											'meeting_duration' => $row['duration'],
											'meeting_method'   => $row['method'],
											'meeting_type'     => $row['type'],
											'meeting_info'     => $row['info'],
										];
									}

									$save_schedule = $this->Batches_model->save_meeting_schedules($meeting_data, true);

									if($save_schedule)
									{
										$msg    = "Berhasil menyimpan data";
										$status = "success";
									}else{
										$msg    = "Gagal menyimpan data";
										$status = "error";
									}
								}else{
									$msg    = "Gagal menyimpan data";
									$status = "error";
								}
							}else{
								$msg    = "Gagal menyimpan data";
								$status = "error";
							}
						}else{
							$msg    = "Gagal menyimpan data";
							$status = "error";
						}
					}
					else
					{
						$msg    = "Gagal menyimpan data";
						$status = "error";	
					}
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}else{
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);

	}

	public function delete()
	{
		$id = $this->input->post('id');
		
		foreach($id as $row)
		{	
			$program_id = $this->Batches_model->batch_header($row)->row()->batch_header_program_id;

			$where = array(
				'batch_id'   => $row,
				'program_id' => $program_id
			);

			$delete_header = $this->Batches_model->delete_header($row);
			
			if($delete_header){
				$delete_type = $this->Batches_model->delete_detail($row);
			}

			if($delete_type){
				$delete_graduate = $this->Batches_model->delete_graduate_advance($where);
			}

			if($delete_graduate){
				$delete_schedule = $this->Batches_model->delete_schedule($where);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

}

?>
